/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.DatalinkServiceUtil;
import cds.aladin.FrameSimple;
import cds.aladin.Glu;
import cds.aladin.ServerGlu;
import cds.aladin.SimpleData;
import cds.aladin.Source;
import cds.aladin.StandardFormsReader;
import cds.savot.model.ParamSet;
import cds.savot.model.SavotOption;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotValues;
import cds.tools.Util;
import cds.xml.Field;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public final class DataLinkGlu {
    public Aladin aladin;
    protected static Vector vGluDLServer;
    public static String PARAMDISABLEDTOOLTIP;
    FrameSimple serviceClientFrame;

    public DataLinkGlu() {
    }

    protected DataLinkGlu(Aladin aladin) {
        this.aladin = aladin;
        vGluDLServer = new Vector(10);
    }

    public String getStandardActionGlu(String formName) {
        return StandardFormsReader.getInstance().getStdServerForms().get(formName);
    }

    protected void createDLGlu(Source activeDataLinkSource, SimpleData selectedDatalink) throws Exception {
        boolean isNonStandardService = true;
        boolean isSODAASync = false;
        Hashtable<String, String> paramDescription = new Hashtable<String, String>();
        Hashtable<String, String> paramDataType = new Hashtable<String, String>();
        Hashtable<String, String> paramValue = new Hashtable<String, String>();
        HashMap<String, String[]> paramRange = new HashMap<String, String[]>();
        StringBuilder urlString = null;
        SavotResource metaResource = selectedDatalink.getMetaResource();
        ParamSet resourceParams = metaResource.getParams();
        SavotParam resourceParam = null;
        ParamSet inputParams = null;
        String boundaryArea_stcs = null;
        ByteArrayInputStream dicStream = null;
        int syncAsyncMode = -1;
        try {
            for (int i = 0; i < resourceParams.getItemCount(); ++i) {
                resourceParam = (SavotParam)resourceParams.getItemAt(i);
                if (resourceParam.getName().equalsIgnoreCase("accessURL") || resourceParam.getName().equalsIgnoreCase("U") || resourceParam.getName().equalsIgnoreCase("Url")) {
                    urlString = new StringBuilder(resourceParam.getValue());
                    continue;
                }
                if (!resourceParam.getName().equalsIgnoreCase("standardID") || !resourceParam.getValue().equalsIgnoreCase("ivo://ivoa.net/std/SODA#sync-1.0") && !resourceParam.getValue().equalsIgnoreCase("ivo://ivoa.net/std/SODA#async-1.0")) continue;
                String sodaGluRecord = this.aladin.datalinkGlu.getStandardActionGlu("SODA_FORM");
                inputParams = DatalinkServiceUtil.getInputParams(metaResource.getGroups()).getParams();
                SavotParam idParam = DatalinkServiceUtil.getInputParams(inputParams, "ID");
                paramValue.put(String.valueOf(7), DataLinkGlu.getParamValue(idParam, selectedDatalink));
                boolean noParamSet = true;
                if (resourceParam.getValue().equalsIgnoreCase("ivo://ivoa.net/std/SODA#async-1.0")) {
                    isSODAASync = true;
                }
                if ((sodaGluRecord = this.addSyncAsyncParam(sodaGluRecord, syncAsyncMode = this.setSyncAsyncMode(isSODAASync))) != null) {
                    dicStream = new ByteArrayInputStream(sodaGluRecord.getBytes(StandardCharsets.UTF_8));
                    noParamSet = this.setSODAFormParams(activeDataLinkSource, paramDescription, paramDataType, paramValue, paramRange);
                } else {
                    paramDescription.put(String.valueOf(7), "ID");
                    paramDataType.put(String.valueOf(7), resourceParam.getDataType());
                    noParamSet = this.setCompleteSODAForm(activeDataLinkSource, selectedDatalink, paramDescription, paramDataType, paramValue, paramRange);
                }
                int sRegionIndex = activeDataLinkSource.findColumn("s_region");
                if (sRegionIndex != -1 && (boundaryArea_stcs = activeDataLinkSource.getValue(sRegionIndex)) != null && !boundaryArea_stcs.isEmpty()) {
                    noParamSet = false;
                }
                if (noParamSet) {
                    this.setSODAFormParams(selectedDatalink, paramDescription, paramDataType, paramValue, paramRange);
                    boundaryArea_stcs = this.getFovFromDatalinkResponse(inputParams);
                }
                isNonStandardService = false;
            }
            if (isNonStandardService) {
                inputParams = DatalinkServiceUtil.getInputParams(metaResource.getGroups()).getParams();
                urlString.append("?");
                SavotParam param = null;
                for (int i = 0; i < inputParams.getItemCount(); ++i) {
                    String index = String.valueOf(i + 1);
                    param = (SavotParam)inputParams.getItemAt(i);
                    paramDescription.put(index, param.getName());
                    paramDataType.put(index, param.getDataType());
                    paramValue.put(index, DataLinkGlu.getParamValue(param, selectedDatalink));
                    DataLinkGlu.addIndexedQueryParameter(urlString, param.getName(), index);
                }
                this.aladin.glu.aladinDic.put("Datalink_Form", urlString.toString());
            } else {
                urlString.append("?POS=CIRCLE+$1+$2+$3&TIME=$4&BAND=$5&POL=$6*&ID=$7");
                this.aladin.glu.aladinDic.put("Datalink_Form", urlString.toString());
                if (syncAsyncMode > 0) {
                    if (isSODAASync) {
                        this.aladin.glu.aladinDic.put("Datalink_Form_async", urlString.toString());
                    } else {
                        this.aladin.glu.aladinDic.put("Datalink_Form_sync", urlString.toString());
                    }
                }
            }
            Vector serverVector = null;
            if (dicStream != null) {
                Glu cfr_ignored_0 = this.aladin.glu;
                Glu.vGluServer = new Vector(50);
                this.aladin.glu.loadGluDic(new DataInputStream(dicStream), true, false);
                Glu cfr_ignored_1 = this.aladin.glu;
                serverVector = Glu.vGluServer;
            } else {
                Vector aladinFilter = new Vector(10);
                StringBuffer record = new StringBuffer(1000);
                record.append("%A ").append("Datalink_Form").append("\n%D Cutout interface for SODA server");
                ServerGlu g = this.serverDataLinks("Datalink_Form", "Cutout service", null, null, null, "Cutout", "Cutout service", null, paramDescription, paramDataType, paramValue, paramRange, "Mime(application/xml)", syncAsyncMode, null, aladinFilter, null, null, null, record, null);
                serverVector = vGluDLServer;
                if (g != null && g.grab != null) {
                    g.grab.setEnabled(true);
                }
            }
            int n = serverVector.size();
            if (n == 0) {
                return;
            }
            ServerGlu dlGlu = (ServerGlu)serverVector.get(0);
            if (!isNonStandardService) {
                String tXelValue;
                dlGlu.setBoundaryAreaStcs(boundaryArea_stcs);
                dlGlu.setDataLinkSource(activeDataLinkSource);
                if (dicStream != null) {
                    dlGlu.setAdditionalGluParams(paramRange, paramValue);
                }
                boolean disableTime = true;
                int tXelIndex = activeDataLinkSource.findColumn("t_xel");
                if (tXelIndex > 0 && (tXelValue = activeDataLinkSource.getValue(tXelIndex)) != null) {
                    try {
                        int tXelIntValue = Integer.parseInt(tXelValue);
                        if (tXelIntValue == 1) {
                            disableTime = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (disableTime) {
                    dlGlu.disableDateField(String.format(PARAMDISABLEDTOOLTIP, "Time"));
                }
            }
            String label = this.getFormLabel(urlString.toString());
            String planeLabel = null;
            if (label != null) {
                planeLabel = !isNonStandardService || isSODAASync ? "[SODA]" + label : "[Cutout]" + label;
            }
            dlGlu.aladinLabel = label;
            dlGlu.planeLabel = planeLabel;
            if (this.serviceClientFrame == null) {
                this.serviceClientFrame = new FrameSimple(this.aladin);
            }
            this.serviceClientFrame.show(dlGlu, "Service " + dlGlu.aladinLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private String getFormLabel(String url) {
        String result = null;
        try {
            result = Util.getDomainNameFromUrl(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String addSyncAsyncParam(String gluRecord, int syncAsyncMode) {
        gluRecord = gluRecord.concat("%ResultSubmitType ") + syncAsyncMode;
        return gluRecord;
    }

    public int setSyncAsyncMode(boolean isSODAASync) {
        int syncAsyncMode = -1;
        if (isSODAASync) {
            String url = this.checkOtherOptionExistsAndGetUrl("ivo://ivoa.net/std/SODA#sync-1.0");
            if (url != null) {
                syncAsyncMode = 2;
                url = url.concat("?POS=CIRCLE+$1+$2+$3&TIME=$4&BAND=$5&POL=$6*&ID=$7");
                this.aladin.glu.aladinDic.put("Datalink_Form_sync", url);
            } else {
                syncAsyncMode = 0;
            }
        } else {
            String url = this.checkOtherOptionExistsAndGetUrl("ivo://ivoa.net/std/SODA#async-1.0");
            if (url != null) {
                syncAsyncMode = 1;
                url = url.concat("?POS=CIRCLE+$1+$2+$3&TIME=$4&BAND=$5&POL=$6*&ID=$7");
                this.aladin.glu.aladinDic.put("Datalink_Form_async", url);
            }
        }
        return syncAsyncMode;
    }

    public String checkOtherOptionExistsAndGetUrl(String standardId) {
        boolean exists = false;
        String urlString = null;
        block0: for (SimpleData datalinkInfo : this.aladin.mesure.activeDataLinkWord.datalinksInfo) {
            urlString = null;
            SavotResource metaResource = datalinkInfo.getMetaResource();
            if (metaResource == null) continue;
            ParamSet resourceParams = metaResource.getParams();
            SavotParam resourceParam = null;
            for (int i = 0; i < resourceParams.getItemCount(); ++i) {
                resourceParam = (SavotParam)resourceParams.getItemAt(i);
                if (resourceParam.getName().equalsIgnoreCase("accessURL") || resourceParam.getName().equalsIgnoreCase("U") || resourceParam.getName().equalsIgnoreCase("Url")) {
                    urlString = resourceParam.getValue();
                } else if (resourceParam.getName().equalsIgnoreCase("standardID") && resourceParam.getValue().equalsIgnoreCase(standardId)) {
                    exists = true;
                }
                if (exists && urlString != null) break block0;
            }
        }
        return urlString;
    }

    private String getFovFromDatalinkResponse(ParamSet inputParamSet) {
        String stcString = null;
        String shape = "POLYGON ICRS ";
        SavotParam param = DatalinkServiceUtil.getInputParams(inputParamSet, "POLYGON");
        if (param == null) {
            param = DatalinkServiceUtil.getInputParams(inputParamSet, "CIRCLE");
            shape = "CIRCLE ICRS ";
        }
        if (param != null && param.getValues() != null && param.getValues().getMax() != null && param.getValues().getMax().getValue() != null && !param.getValues().getMax().getValue().isEmpty()) {
            stcString = shape + param.getValues().getMax().getValue();
        }
        return stcString;
    }

    public ServerGlu getDataLinkServerGlu() {
        return (ServerGlu)vGluDLServer.get(0);
    }

    public boolean setCompleteSODAForm(Source activeDatalinkSource, SimpleData selectedDatalink, Hashtable<String, String> paramDescription, Hashtable<String, String> paramDataType, Hashtable<String, String> paramValue, HashMap<String, String[]> paramRange) {
        if (activeDatalinkSource == null) {
            return false;
        }
        this.setSODATargetParameter(paramDescription, paramDataType, paramValue);
        return this.setSODAFormParams(activeDatalinkSource, paramDescription, paramDataType, paramValue, paramRange);
    }

    public boolean setSODAFormParams(Source activeDatalinkSource, Hashtable<String, String> paramDescription, Hashtable<String, String> paramDataType, Hashtable<String, String> paramValue, HashMap<String, String[]> paramRange) {
        boolean noFieldSet = DataLinkGlu.setSODAFormParam(activeDatalinkSource, String.valueOf(4), paramDescription, paramDataType, "Date(ParseToMJD)", paramValue, "SETFORMVALUES", paramRange, "Time", activeDatalinkSource.findColumn("t_min"), activeDatalinkSource.findColumn("t_max"));
        noFieldSet |= DataLinkGlu.setSODAFormParam(activeDatalinkSource, String.valueOf(5), paramDescription, paramDataType, "Band(SODA)", paramValue, "SETFORMVALUES", paramRange, "Band", activeDatalinkSource.findColumn("em_min"), activeDatalinkSource.findColumn("em_max"));
        int polStatesIndex = activeDatalinkSource.findColumn("pol_states");
        String pol_states = null;
        if (polStatesIndex != -1) {
            pol_states = activeDatalinkSource.getValue(polStatesIndex);
        }
        if (pol_states == null || pol_states.isEmpty()) {
            pol_states = "I\tQ\tU\tV\tRR\tLL\tRL\tLR\tXX\tYY\tXY\tYX\tPOLI\tPOLA";
        } else {
            noFieldSet = false;
        }
        DataLinkGlu.setSODAFormParam(activeDatalinkSource, String.valueOf(6), paramDescription, paramDataType, "char(Multiselect)", paramValue, pol_states, paramRange, "Pol", activeDatalinkSource.findColumn("pol_states"), -1);
        return noFieldSet;
    }

    public boolean setSODAFormParams(SimpleData selectedDatalink, Hashtable<String, String> paramDescription, Hashtable<String, String> paramDataType, Hashtable<String, String> paramValue, HashMap<String, String[]> paramRange) {
        DataLinkGlu.setSODAFormParam(selectedDatalink, String.valueOf(4), paramDescription, paramDataType, "Date(ParseToMJD)", paramValue, "SETFORMVALUES", paramRange, "Time");
        DataLinkGlu.setSODAFormParam(selectedDatalink, String.valueOf(5), paramDescription, paramDataType, "Band(SODA)", paramValue, "SETFORMVALUES", paramRange, "Band");
        String pol_states = "I\tQ\tU\tV\tRR\tLL\tRL\tLR\tXX\tYY\tXY\tYX\tPOLI\tPOLA";
        DataLinkGlu.setSODAFormParam(selectedDatalink, String.valueOf(6), paramDescription, paramDataType, "char(Multiselect)", paramValue, pol_states, paramRange, "Pol");
        return true;
    }

    public static boolean setSODAFormParam(SimpleData selectedDatalink, String paramFormIndex, Hashtable<String, String> paramDescription, Hashtable<String, String> paramDataType, String paramDataTypeDefault, Hashtable<String, String> paramValue, String paramDefaultValue, HashMap<String, String[]> paramRange, String paramName) {
        SavotValues savotValues;
        String dlParamValue;
        paramDescription.put(paramFormIndex, paramName);
        ParamSet inputParams = DatalinkServiceUtil.getInputParams(selectedDatalink.getMetaResource().getGroups()).getParams();
        SavotParam ipParam = DatalinkServiceUtil.getInputParams(inputParams, paramName);
        if (paramDataTypeDefault == null) {
            if (ipParam != null && ipParam.getDataType() != null && !ipParam.getDataType().isEmpty()) {
                paramDataType.put(paramFormIndex, Field.typeVOTable2Fits(ipParam.getDataType()));
            }
        } else {
            paramDataType.put(paramFormIndex, paramDataTypeDefault);
        }
        String lowerLimit = null;
        String upperLimit = null;
        if (ipParam != null && ((dlParamValue = DataLinkGlu.getParamValue(ipParam, selectedDatalink)) == null || dlParamValue.isEmpty()) && (savotValues = ipParam.getValues()) != null) {
            if (savotValues.getMin() != null && savotValues.getMax() != null) {
                lowerLimit = savotValues.getMin().getValue();
                upperLimit = savotValues.getMax().getValue();
            } else if (savotValues.getOptions() != null) {
                StringBuffer optionString = new StringBuffer();
                boolean isNotFirst = false;
                for (SavotOption option : savotValues.getOptions().getItems()) {
                    if (isNotFirst) {
                        optionString.append("/");
                    }
                    optionString.append(option.getValue());
                    isNotFirst = true;
                }
                paramDefaultValue = optionString.toString();
            }
        }
        return DataLinkGlu.setValueAndRange(paramFormIndex, paramValue, paramDefaultValue, paramRange, paramName, lowerLimit, upperLimit);
    }

    public void setSODATargetParameter(Hashtable<String, String> paramDescription, Hashtable<String, String> paramDataType, Hashtable<String, String> paramValue) {
        paramDescription.put(String.valueOf(1), "Right Ascension");
        paramDescription.put(String.valueOf(2), "Declination");
        paramDescription.put(String.valueOf(3), "Dimensions");
        paramDataType.put(String.valueOf(1), "Target(RAd)");
        paramDataType.put(String.valueOf(2), "Target(DEd)");
        paramDataType.put(String.valueOf(3), "Field(STRINGd)");
        paramValue.put(String.valueOf(1), "");
        paramValue.put(String.valueOf(2), "");
        paramValue.put(String.valueOf(3), "");
    }

    public static boolean setSODAFormParam(Source activeDatalinkSource, String paramFormIndex, Hashtable<String, String> paramDescription, Hashtable<String, String> paramDataType, String paramDataTypeDefault, Hashtable<String, String> paramValue, String paramDefaultValue, HashMap<String, String[]> paramRange, String paramName, int lowerLimitIndex, int upperLimitIndex) {
        paramDescription.put(paramFormIndex, paramName);
        if (paramDataTypeDefault == null) {
            if (activeDatalinkSource != null && lowerLimitIndex != -1) {
                Field[] field = activeDatalinkSource.getLeg().field;
                paramDataType.put(paramFormIndex, field[lowerLimitIndex].datatype);
            }
        } else {
            paramDataType.put(paramFormIndex, paramDataTypeDefault);
        }
        String lowerLimit = null;
        String upperLimit = null;
        if (upperLimitIndex != -1) {
            lowerLimit = activeDatalinkSource.getValue(lowerLimitIndex);
            upperLimit = activeDatalinkSource.getValue(upperLimitIndex);
        }
        return DataLinkGlu.setValueAndRange(paramFormIndex, paramValue, paramDefaultValue, paramRange, paramName, lowerLimit, upperLimit);
    }

    public static boolean setValueAndRange(String paramFormIndex, Hashtable<String, String> paramValue, String paramDefaultValue, HashMap<String, String[]> paramRange, String paramName, String lowerLimit, String upperLimit) {
        boolean noFieldSet = true;
        if (upperLimit != null) {
            String[] anArray = new String[14];
            anArray[0] = lowerLimit;
            anArray[1] = upperLimit;
            paramRange.put(paramFormIndex, anArray);
            if (lowerLimit != null && !lowerLimit.isEmpty() && upperLimit != null && !upperLimit.isEmpty() && paramDefaultValue.equalsIgnoreCase("SETFORMVALUES")) {
                String delimiter = " ";
                if (paramName.equalsIgnoreCase("Time")) {
                    delimiter = ",";
                }
                StringBuffer paramValueDisplay = new StringBuffer(lowerLimit).append(delimiter).append(upperLimit);
                paramValue.put(paramFormIndex, paramValueDisplay.toString());
                noFieldSet = false;
            }
        } else if (!paramDefaultValue.equalsIgnoreCase("SETFORMVALUES")) {
            if (paramDefaultValue.contains("/")) {
                paramValue.put(paramFormIndex, paramDefaultValue.replaceAll("/", "\t"));
                String[] paramDefaultValues = paramDefaultValue.split("/");
                String[] anArray = Arrays.copyOf(paramDefaultValues, 14);
                paramRange.put(paramFormIndex, anArray);
            } else {
                paramValue.put(paramFormIndex, paramDefaultValue);
            }
        }
        return noFieldSet;
    }

    public static String getSODAParamHint(String lowerLimitValue, String upperLimitValue) {
        String result = "Field limit unknown...";
        if (lowerLimitValue != null && upperLimitValue != null && !lowerLimitValue.replaceAll("\\s", "").equalsIgnoreCase("") && !upperLimitValue.replaceAll("\\s", "").equalsIgnoreCase("")) {
            StringBuffer sodaHint = new StringBuffer("Valid Range: ").append(lowerLimitValue);
            sodaHint.append(" > ").append(upperLimitValue);
            result = sodaHint.toString();
        }
        return result;
    }

    public ServerGlu serverDataLinks(String actionName, String description, String verboseDescr, String aladinMenu, String aladinMenuNumber, String aladinLabel, String aladinLabelPlane, String docUser, Hashtable paramDescription1, Hashtable paramDataType1, Hashtable paramValue1, HashMap<String, String[]> paramRange2, String resultDataType, int showSyncAsync, String institute, Vector aladinFilter1, String aladinLogo, String dir, String system, StringBuffer record, String aladinProtocol) {
        int i;
        if (paramDescription1 == null) {
            return null;
        }
        int n = paramDescription1.size();
        String[] paramDescription = new String[n];
        for (i = 1; i <= n; ++i) {
            paramDescription[i - 1] = (String)paramDescription1.get(i + "");
        }
        String[] paramDataType = new String[n];
        for (i = 1; i <= n; ++i) {
            paramDataType[i - 1] = (String)paramDataType1.get(i + "");
        }
        String[] paramValue = new String[n];
        for (i = 1; i <= n; ++i) {
            paramValue[i - 1] = (String)paramValue1.get(i + "");
        }
        String[][] paramRange = new String[n][14];
        for (i = 1; i <= n; ++i) {
            String[] paramRanges = paramRange2.get(i + "");
            if (paramRanges != null) {
                for (int j = 0; j < 14; ++j) {
                    paramRange[i - 1][j] = String.valueOf(paramRange2.get(i + "")[j]);
                }
                continue;
            }
            paramRange[i - 1][0] = null;
            paramRange[i - 1][1] = null;
        }
        String[] aladinFilter = null;
        if (aladinFilter1 != null && (n = aladinFilter1.size()) > 0) {
            aladinFilter = new String[n];
            Enumeration e = aladinFilter1.elements();
            for (i = 0; i < n; ++i) {
                aladinFilter[i] = (String)e.nextElement();
            }
        }
        if (system != null && system.trim().length() == 0) {
            system = null;
        }
        if (institute == null) {
            institute = description;
        }
        ServerGlu g = null;
        if (this.aladin != null) {
            g = new ServerGlu(this.aladin, actionName, description, verboseDescr, aladinMenu, aladinMenuNumber, aladinLabel, aladinLabelPlane, docUser, paramDescription, paramDataType, paramValue, paramRange, resultDataType, showSyncAsync, institute, aladinFilter, aladinLogo, dir, system, record, aladinProtocol, null, null, null, false);
            vGluDLServer.clear();
            vGluDLServer.addElement(g);
        }
        return g;
    }

    public static void addIndexedQueryParameter(StringBuilder queryString, String name, Object value) throws UnsupportedEncodingException {
        if (queryString != null) {
            queryString.append(URLEncoder.encode(name, "utf-8")).append("=").append("$").append(URLEncoder.encode(value.toString(), "utf-8")).append("&");
        }
    }

    public static String getParamValue(SavotParam param, SimpleData selectedDatalink) {
        String value = "";
        value = param.getRef() != null && !param.getRef().isEmpty() ? selectedDatalink.getParams().get(param.getRef()) : param.getValue();
        return value;
    }

    static {
        PARAMDISABLEDTOOLTIP = Aladin.getChaine().getString("PARAMDISABLEDTOOLTIP");
    }
}

